/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.util.Graph;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.apache.commons.lang3.mutable.MutableInt;

public abstract class BiomeSource
implements BiomeResolver {
    public static final Codec<BiomeSource> f_47888_;
    private final Set<Holder<Biome>> f_47891_;
    private final Supplier<List<StepFeatureData>> f_186695_;

    protected BiomeSource(Stream<Holder<Biome>> p_47896_) {
        this(p_47896_.distinct().toList());
    }

    protected BiomeSource(List<Holder<Biome>> p_47894_) {
        this.f_47891_ = new ObjectLinkedOpenHashSet(p_47894_);
        this.f_186695_ = Suppliers.memoize(() -> this.m_186727_(p_47894_, true));
    }

    private List<StepFeatureData> m_186727_(List<Holder<Biome>> p_186728_, boolean p_186729_) {
        Object2IntOpenHashMap $$2 = new Object2IntOpenHashMap();
        MutableInt $$3 = new MutableInt(0);
        record FeatureData(int f_186739_, int f_186740_, PlacedFeature f_186741_) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{FeatureData.class, "featureIndex;step;feature", "f_186739_", "f_186740_", "f_186741_"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FeatureData.class, "featureIndex;step;feature", "f_186739_", "f_186740_", "f_186741_"}, this);
            }

            @Override
            public final boolean equals(Object p_186750_) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FeatureData.class, "featureIndex;step;feature", "f_186739_", "f_186740_", "f_186741_"}, this, p_186750_);
            }
        }
        Comparator<FeatureData> $$4 = Comparator.comparingInt(FeatureData::f_186740_).thenComparingInt(FeatureData::f_186739_);
        TreeMap<FeatureData, Set> $$5 = new TreeMap<FeatureData, Set>($$4);
        int $$6 = 0;
        for (Holder<Biome> $$7 : p_186728_) {
            Biome $$8 = $$7.m_203334_();
            ArrayList $$9 = Lists.newArrayList();
            List<HolderSet<PlacedFeature>> $$10 = $$8.m_47536_().m_47818_();
            $$6 = Math.max($$6, $$10.size());
            for (int $$11 = 0; $$11 < $$10.size(); ++$$11) {
                for (Holder holder : $$10.get($$11)) {
                    PlacedFeature $$13 = (PlacedFeature)holder.m_203334_();
                    $$9.add(new FeatureData($$2.computeIfAbsent((Object)$$13, p_204235_ -> $$3.getAndIncrement()), $$11, $$13));
                }
            }
            for (int $$14 = 0; $$14 < $$9.size(); ++$$14) {
                Set $$15 = $$5.computeIfAbsent((FeatureData)$$9.get($$14), p_204230_ -> new TreeSet($$4));
                if ($$14 >= $$9.size() - 1) continue;
                $$15.add((FeatureData)$$9.get($$14 + 1));
            }
        }
        TreeSet<FeatureData> $$16 = new TreeSet<FeatureData>($$4);
        TreeSet<FeatureData> $$17 = new TreeSet<FeatureData>($$4);
        ArrayList $$18 = Lists.newArrayList();
        for (FeatureData $$19 : $$5.keySet()) {
            if (!$$17.isEmpty()) {
                throw new IllegalStateException("You somehow broke the universe; DFS bork (iteration finished with non-empty in-progress vertex set");
            }
            if ($$16.contains($$19) || !Graph.m_184556_($$5, $$16, $$17, $$18::add, $$19)) continue;
            if (p_186729_) {
                int $$21;
                ArrayList<Holder<Biome>> $$20 = new ArrayList<Holder<Biome>>(p_186728_);
                do {
                    $$21 = $$20.size();
                    ListIterator<Holder> listIterator = $$20.listIterator();
                    while (listIterator.hasNext()) {
                        Holder $$23 = (Holder)listIterator.next();
                        listIterator.remove();
                        try {
                            this.m_186727_($$20, false);
                        }
                        catch (IllegalStateException $$24) {
                            continue;
                        }
                        listIterator.add($$23);
                    }
                } while ($$21 != $$20.size());
                throw new IllegalStateException("Feature order cycle found, involved biomes: " + $$20);
            }
            throw new IllegalStateException("Feature order cycle found");
        }
        Collections.reverse($$18);
        ImmutableList.Builder $$25 = ImmutableList.builder();
        for (int $$26 = 0; $$26 < $$6; ++$$26) {
            int $$27 = $$26;
            List<PlacedFeature> $$28 = $$18.stream().filter(p_204227_ -> p_204227_.f_186740_() == $$27).map(FeatureData::f_186741_).collect(Collectors.toList());
            int n = $$28.size();
            Object2IntOpenCustomHashMap $$30 = new Object2IntOpenCustomHashMap(n, Util.m_137583_());
            for (int $$31 = 0; $$31 < n; ++$$31) {
                $$30.put((Object)((PlacedFeature)$$28.get($$31)), $$31);
            }
            $$25.add((Object)new StepFeatureData($$28, (ToIntFunction<PlacedFeature>)$$30));
        }
        return $$25.build();
    }

    protected abstract Codec<? extends BiomeSource> m_5820_();

    public abstract BiomeSource m_7206_(long var1);

    public Set<Holder<Biome>> m_207840_() {
        return this.f_47891_;
    }

    public Set<Holder<Biome>> m_183399_(int p_186705_, int p_186706_, int p_186707_, int p_186708_, Climate.Sampler p_186709_) {
        int $$5 = QuartPos.m_175400_(p_186705_ - p_186708_);
        int $$6 = QuartPos.m_175400_(p_186706_ - p_186708_);
        int $$7 = QuartPos.m_175400_(p_186707_ - p_186708_);
        int $$8 = QuartPos.m_175400_(p_186705_ + p_186708_);
        int $$9 = QuartPos.m_175400_(p_186706_ + p_186708_);
        int $$10 = QuartPos.m_175400_(p_186707_ + p_186708_);
        int $$11 = $$8 - $$5 + 1;
        int $$12 = $$9 - $$6 + 1;
        int $$13 = $$10 - $$7 + 1;
        HashSet $$14 = Sets.newHashSet();
        for (int $$15 = 0; $$15 < $$13; ++$$15) {
            for (int $$16 = 0; $$16 < $$11; ++$$16) {
                for (int $$17 = 0; $$17 < $$12; ++$$17) {
                    int $$18 = $$5 + $$16;
                    int $$19 = $$6 + $$17;
                    int $$20 = $$7 + $$15;
                    $$14.add(this.m_203407_($$18, $$19, $$20, p_186709_));
                }
            }
        }
        return $$14;
    }

    @Nullable
    public Pair<BlockPos, Holder<Biome>> m_207829_(int p_207830_, int p_207831_, int p_207832_, int p_207833_, Predicate<Holder<Biome>> p_207834_, Random p_207835_, Climate.Sampler p_207836_) {
        return this.m_207481_(p_207830_, p_207831_, p_207832_, p_207833_, 1, p_207834_, p_207835_, false, p_207836_);
    }

    @Nullable
    public Pair<BlockPos, Holder<Biome>> m_207481_(int p_207820_, int p_207821_, int p_207822_, int p_207823_, int p_207824_, Predicate<Holder<Biome>> p_207825_, Random p_207826_, boolean p_207827_, Climate.Sampler p_207828_) {
        int $$15;
        int $$9 = QuartPos.m_175400_(p_207820_);
        int $$10 = QuartPos.m_175400_(p_207822_);
        int $$11 = QuartPos.m_175400_(p_207823_);
        int $$12 = QuartPos.m_175400_(p_207821_);
        Pair $$13 = null;
        int $$14 = 0;
        for (int $$16 = $$15 = p_207827_ ? 0 : $$11; $$16 <= $$11; $$16 += p_207824_) {
            int $$17;
            int n = $$17 = SharedConstants.f_183698_ ? 0 : -$$16;
            while ($$17 <= $$16) {
                boolean $$18 = Math.abs($$17) == $$16;
                for (int $$19 = -$$16; $$19 <= $$16; $$19 += p_207824_) {
                    int $$22;
                    int $$21;
                    Holder<Biome> $$23;
                    if (p_207827_) {
                        boolean $$20;
                        boolean bl = $$20 = Math.abs($$19) == $$16;
                        if (!$$20 && !$$18) continue;
                    }
                    if (!p_207825_.test($$23 = this.m_203407_($$21 = $$9 + $$19, $$12, $$22 = $$10 + $$17, p_207828_))) continue;
                    if ($$13 == null || p_207826_.nextInt($$14 + 1) == 0) {
                        BlockPos $$24 = new BlockPos(QuartPos.m_175402_($$21), p_207821_, QuartPos.m_175402_($$22));
                        if (p_207827_) {
                            return Pair.of((Object)$$24, $$23);
                        }
                        $$13 = Pair.of((Object)$$24, $$23);
                    }
                    ++$$14;
                }
                $$17 += p_207824_;
            }
        }
        return $$13;
    }

    @Override
    public abstract Holder<Biome> m_203407_(int var1, int var2, int var3, Climate.Sampler var4);

    public void m_207301_(List<String> p_207837_, BlockPos p_207838_, Climate.Sampler p_207839_) {
    }

    public List<StepFeatureData> m_186733_() {
        return this.f_186695_.get();
    }

    static {
        Registry.m_122961_(Registry.f_122889_, "fixed", FixedBiomeSource.f_48251_);
        Registry.m_122961_(Registry.f_122889_, "multi_noise", MultiNoiseBiomeSource.f_48425_);
        Registry.m_122961_(Registry.f_122889_, "checkerboard", CheckerboardColumnBiomeSource.f_48230_);
        Registry.m_122961_(Registry.f_122889_, "the_end", TheEndBiomeSource.f_48617_);
        f_47888_ = Registry.f_122889_.m_194605_().dispatchStable(BiomeSource::m_5820_, Function.identity());
    }

    public record StepFeatureData(List<PlacedFeature> f_196677_, ToIntFunction<PlacedFeature> f_196678_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{StepFeatureData.class, "features;indexMapping", "f_196677_", "f_196678_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{StepFeatureData.class, "features;indexMapping", "f_196677_", "f_196678_"}, this);
        }

        @Override
        public final boolean equals(Object p_196685_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{StepFeatureData.class, "features;indexMapping", "f_196677_", "f_196678_"}, this, p_196685_);
        }
    }
}

